/*

- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	AMX Mod X Script
	
	Plugin: Hide N Seek
	Version: 4.51
	Author: Jon ( Перевод: jiF )
        
	Link: http://forums.alliedmods.net/showthread.php?t=73244
        
        This program is free software; you can redistribute it and/or modify it
        under the terms of the GNU General Public License as published by the
        Free Software Foundation; either version 2 of the License, or (at
        your option) any later version.

        This program is distributed in the hope that it will be useful, but
        WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
        General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software Foundation,
        Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

        In addition, as a special exception, the author gives permission to
        link the code of this program with the Half-Life Game Engine ("HL
        Engine") and Modified Game Libraries ("MODs") developed by Valve,
        L.L.C ("Valve"). You must obey the GNU General Public License in all
        respects for all of the code used other than the HL Engine and MODs
        from Valve. If you modify this file, you may extend this exception
        to your version of the file, but you are not obligated to do so. If
        you do not wish to do so, delete this exception statement from your
        version.

- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	
	_ Description _
	
	* Terrorists will have a certain amount of time to hide when the CTs are frozen.
	* When the hidingtime is over, the Terrorists, who have no weapons, must avoid getting killed by the CTs.
	* Teams will swap when all terrorists are killed or when x rounds have passed (cvar controlled).
	* Deathmatch Mode: Instant teamswitch for CTs that kill Ts (cvar controlled).
	
	_ Credits _
	
	* OneEyed - Original idea
	* Alka - Anything I might have asked for
	* ConnorMcLeod - Block buying code
	* jiF - Translate Plugin
*/

#include <amxmodx>
#include <engine>
#include <fakemeta>
#include <hamsandwich>
#include <cstrike>
#include <fun>

#define PLUGIN "Hide N Seek"
#define VERSION "4.51"
#define AUTHOR "Jon"

#if cellbits == 32
	#define OFFSET_BUYZONE 235
#else
	#define OFFSET_BUYZONE 268
#endif

// - // - // - // - // - // - // - //

#define MENU_KEYS ( 1<<0 | 1<<1 )
#define InTeam(%1) ( CS_TEAM_UNASSIGNED < cs_get_user_team(%1) < CS_TEAM_SPECTATOR )

const TASK_RESPAWN = 11001;
const TASK_SHOWMENU = 12002;

const Float:SEMICLIP_DISTANCE = 100.0
const Float:VOTETYPE_DELAY = 20.0

new const g_szDefaultEntities[][] =
{
	"func_hostage_rescue", 
	"info_hostage_rescue", 
	"func_bomb_target", 
	"info_bomb_target", 
	"hostage_entity",
	"info_vip_start", 
	"func_vip_safetyzone", 
	"func_escapezone",
	"func_buyzone"
};

new const g_szTimerClassName[] = "hns_timer";
new const g_szKnifeDeploy[] = "weapons/knife_deploy1.wav";
new const g_szBuyzone[] = "buyzone";
new const g_szDoor[] = "func_door";
new const g_szDoorRotating[] = "func_door_rotating";
new const g_szBreakable[] = "func_breakable";

new g_pEnable;
new g_pVoteGameType;
new g_pHalfWayVote;
new g_pDeathmatch;
new g_pTimer;
new g_pSound;
new g_pGameName;
new g_pFadeColor;
new g_pSwitch;
new g_pSlash;
new g_pSemiClip;
new g_pRemoveBreakables;
new g_pRemoveDoors;
new g_pPickup;
new g_pNadesBeginning;
new g_pNewNades;
new g_pFakeKnife;
new g_pNoFlash;
new g_pFootSteps;
new g_pFlashbangs;
new g_pSmokeGrenade;
new g_pHeGrenade;
new g_pBlockKill;
new g_pChooseTeam;

new g_iTimer;
new g_iMaxPlayers;
new g_iHudSync;
new g_iMapMiddleTime;
new g_iMsgScreenFade;
new g_iMsgSayText;
new g_iTimerEntity;
new g_iRegisterSpawn;
new g_iHostageEntity;
new g_iRoundsLost;
new g_iVotes[ 2 ];
new g_iTeam[ 33 ];
new g_szNadeMenu[ 64 ];
new g_szVoteMenu[ 96 ];

new bool:g_bStarted;
new bool:g_bSecondVote;
new bool:g_bAllowSlash;
new bool:g_bAlive[ 33 ];
new bool:g_bConnected[ 33 ];
new bool:g_bSolid[ 33 ];
new bool:g_bRestore[ 33 ];
new bool:g_bVoted[ 33 ];

// - // - // - // - // - // - // - //

public plugin_precache()
{
	g_iHudSync = CreateHudSyncObj();
	g_pRemoveDoors = register_cvar( "hns_removedoors", "1" );
	g_pRemoveBreakables = register_cvar( "hns_removebreakables", "1" );
	g_iRegisterSpawn = register_forward( FM_Spawn, "fwdSpawn", 1 );
}

public plugin_init()
{
	register_plugin( PLUGIN, VERSION, AUTHOR );
	register_cvar( "hns_version", VERSION, FCVAR_SERVER | FCVAR_SPONLY ); 
	
	g_pEnable = register_cvar( "hns_enable", "1" );
	g_pDeathmatch = register_cvar( "hns_deathmatch", "0" );
	g_pVoteGameType = register_cvar( "hns_votegametype", "1" ) ;
	g_pTimer =  register_cvar( "hns_timer", "10" );
	g_pGameName = register_cvar( "hns_gamename", "Hide N Seek" );
	g_pHalfWayVote = register_cvar( "hns_halfwayvote", "1" );
	g_pSound = register_cvar( "hns_sound", "1" );
	g_pSwitch = register_cvar( "hns_switch", "5" );
	g_pSlash = register_cvar( "hns_slash", "3" );
	g_pFadeColor = register_cvar( "hns_fadecolor", "0 0 0 255" );
	g_pNadesBeginning = register_cvar( "hns_nadesbeginning", "0" );
	g_pFootSteps = register_cvar( "hns_footsteps", "1" );
	g_pPickup = register_cvar( "hns_pickup", "1" );
	g_pFakeKnife = register_cvar( "hns_fakeknife", "1" );
	g_pNewNades = register_cvar( "hns_newnades", "1" );
	g_pNoFlash = register_cvar( "hns_noflash", "1" );
	g_pSemiClip = register_cvar( "hns_semiclip", "1" );
	g_pFlashbangs = register_cvar( "hns_flashbangs", "2" );
	g_pHeGrenade = register_cvar( "hns_hegrenade", "0" );
	g_pSmokeGrenade = register_cvar( "hns_smokegrenade", "1" );
	g_pChooseTeam = register_cvar( "hns_chooseteam", "0" );
	g_pBlockKill = register_cvar( "hns_blockkill", "1" );

	g_iMsgScreenFade = get_user_msgid( "ScreenFade" );
	g_iMsgSayText = get_user_msgid( "SayText" );
	g_iMapMiddleTime = ( get_cvar_num( "mp_timelimit" ) / 2 ) * 60;
	g_iMaxPlayers = get_maxplayers();
	g_iTimerEntity = create_entity( "info_target" );
	
	entity_set_string( g_iTimerEntity, EV_SZ_classname, g_szTimerClassName );
	
	register_logevent( "eventRoundStart", 2, "0=World triggered", "1=Round_Start" );
	register_logevent( "eventRoundEnd", 2, "0=World triggered", "1=Round_Draw", "1=Round_End" );

	register_event( "HLTV", "eventNewRound", "a", "1=0", "2=0" );
	register_event( "CurWeapon", "eventSelectKnife", "be", "1=1", "2=29" );
	register_event( "DeathMsg", "eventDeathMsg", "a" );
	register_event( "TextMsg","eventJoinTeam", "a", "1=1", "2&Game_join_te","2&Game_join_ct" )
	
	set_msg_block( get_user_msgid( "HostagePos" ), BLOCK_SET );
	register_message( get_user_msgid( "StatusIcon" ), "msgStatusIcon" );
	register_message( get_user_msgid( "TextMsg" ), "msgTextMsg" );
	register_message( g_iMsgScreenFade, "msgScreenFade" );
	
	unregister_forward( FM_Spawn, g_iRegisterSpawn, 1 );
	register_forward( FM_AddToFullPack, "fwdFullPack", 1 );
	register_forward( FM_EmitSound, "fwdEmitSound" ) ;
	register_forward( FM_CmdStart, "fwdCmdStart" );
	register_forward( FM_ClientKill, "fwdClientKill" );
	register_forward( FM_GetGameDescription,"fwdGameDesc" );
	
	RegisterHam( Ham_Spawn, "player", "fwdPlayerSpawn", 1 );
	RegisterHam( Ham_Touch, "armoury_entity", "fwdTouchWeapon" );
	RegisterHam( Ham_Touch, "weaponbox", "fwdTouchWeapon" );
	
	register_think( g_szTimerClassName, "fwdTimerThink" );
	
	register_clcmd( "chooseteam", "cmdTeamSelect" );
	register_clcmd( "jointeam",  "cmdTeamSelect" );

	if( get_pcvar_num( g_pVoteGameType ) && get_pcvar_num( g_pDeathmatch ) )
	{
		set_pcvar_num( g_pDeathmatch, 0 );
	}
	
	if( !get_pcvar_num( g_pDeathmatch ) )
	{
		g_iHostageEntity = create_entity( "hostage_entity" );
		
		entity_set_origin( g_iHostageEntity, Float:{ 0.0, 0.0, -55000.0 } );
		entity_set_size( g_iHostageEntity, Float:{ -1.0, -1.0, -1.0 }, Float:{ 1.0, 1.0, 1.0 } );
		DispatchSpawn( g_iHostageEntity );
	}
}

public plugin_cfg()
{
	new iLen = charsmax( g_szNadeMenu );
	
	add( g_szNadeMenu, iLen, "\yНужна граната?^n^n" );
	add( g_szNadeMenu, iLen, "\r1. \wДа^n" );
	add( g_szNadeMenu, iLen, "\r2. \wНет" );
	
	register_menucmd( register_menuid( "NadesMenu" ), MENU_KEYS, "HandleNadeMenu" );
	
	if( get_pcvar_num( g_pVoteGameType ) )
	{
		iLen = charsmax( g_szVoteMenu );
		
		add( g_szVoteMenu, iLen, "\yВыбиpeтe режим игры^n^n" );
		add( g_szVoteMenu, iLen, "\r1. \wHopмaльный \y[%i]^n" );
		add( g_szVoteMenu, iLen, "\r2. \wDM peжим \y[%i]" );
		
		register_menucmd( register_menuid( "menuGameType" ), MENU_KEYS, "HandleTypeMenu" );
		
		set_task( VOTETYPE_DELAY, "taskTypeVote" );
	}
}

public client_putinserver(id)
{
	g_bConnected[ id ] = true;
}

public client_disconnect(id)
{
	remove_task( id + TASK_SHOWMENU );
	remove_task( id + TASK_RESPAWN );
	
	g_bConnected[ id ] = false;
	g_bAlive[ id ] = false;
	g_bRestore[ id ] = false;
	g_bSolid[ id ] = false;
	g_bVoted[ id ] = false;
	g_iTeam[ id ] = 0;
}

public eventNewRound()
{
	if( get_pcvar_num( g_pEnable ) && GetPlayers() )
	{
		g_bStarted = true;
		g_iTimer = get_pcvar_num( g_pTimer );
	}
}

public eventRoundStart()
{
	if( g_bStarted )
	{
		entity_set_float( g_iTimerEntity, EV_FL_nextthink, get_gametime() );
	}
}

public eventRoundEnd()
{
	if( !GetPlayers() || !g_bStarted )
	{
		return PLUGIN_CONTINUE;
	}
	
	new iPlayers[ 32 ], iNum;
	get_players( iPlayers, iNum, "ae", "TERRORIST" );
	
	if( !iNum || g_iRoundsLost == get_pcvar_num( g_pSwitch ) )
	{	
		for( new i = 1; i <= g_iMaxPlayers; i++ )
		{
			if( g_bConnected[ i ] )
			{
				switch( cs_get_user_team( i ) )
				{
					case CS_TEAM_T:
					{
						cs_set_user_team( i, CS_TEAM_CT );
					}
					
					case CS_TEAM_CT:
					{
						cs_set_user_team( i, CS_TEAM_T );
					}
				}
			}
		}
		
		if( !iNum )
		{
			set_hudmessage( 0, 128, 255, -1.0, 0.82, 1, 0.0, 5.0, 0.1, 0.2, 1 );
			ShowSyncHudMsg( 0, g_iHudSync, "Ишюшиe выйграли!" );
		}
		
		else
		{
			set_hudmessage( 0, 255, 0, -1.0, 0.82, 1, 0.0, 5.0, 0.1, 0.2, 1 );
			ShowSyncHudMsg( 0, g_iHudSync, "%i Ничья!", g_iRoundsLost );
		}
		
		g_bAllowSlash = false;
		g_iRoundsLost = 0;
	}
	
	else
	{
		g_iRoundsLost++;
		
		set_hudmessage( 255, 0, 0, -1.0, 0.82, 1, 0.0, 5.0, 0.1, 0.2, 1 );
		ShowSyncHudMsg( 0, g_iHudSync, "Прятающиеся выйграли!" );	
	}
	
	g_bStarted = false;
	
	return PLUGIN_CONTINUE;
}

public eventDeathMsg()
{
	new iKiller = read_data( 1 ), iVictim = read_data( 2 );
	
	g_bAlive[ iVictim ] = false;
	
	if( cs_get_user_team( iVictim ) == CS_TEAM_T )
	{
		if( get_pcvar_num( g_pDeathmatch ) )
		{
			if( iKiller != iVictim )
			{
				cs_set_user_team( iVictim, CS_TEAM_CT );
				
				if( iKiller > 0 )
				{
					MakeHiderDm( iKiller );
				}
				
				else
				{
					new iPlayers[ 32 ], iNum, iCT;
					get_players( iPlayers, iNum, "ae", "CT" );
					
					iCT = iNum > 0 ? iPlayers[ random( iNum - 1 ) ] : 0;
					
					new iTs, iCTs;
					GetPlayers( iTs, iCTs );
					
					if( iCT > 0 && iTs < iCTs )
					{
						MakeHiderDm( iCT );
						
						GreenPrint( iCT, "Вы были перемещены за Терраристов" );
					}
				}
			}
			
			// No proper event for checking timelimit, doing here.
			if( get_pcvar_num( g_pHalfWayVote ) && get_pcvar_num( g_pVoteGameType ) )
			{
				if( g_iMapMiddleTime < get_gametime() && !g_bSecondVote )
				{
					g_bSecondVote = true;
		
					taskTypeVote();
				}
			}
			
			set_task( 2.5, "taskRespawn", iVictim + TASK_RESPAWN );
		}
		
		else if( get_pcvar_num( g_pNewNades ) && g_bStarted )
		{
			new iPlayers[ 32 ], iNum;
			get_players( iPlayers, iNum, "ae", "TERRORIST" );
			
			if( iNum == 1 )
			{
				show_menu( iPlayers[ 0 ], MENU_KEYS, g_szNadeMenu, 5, "NadesMenu" );
			}
		}
	}
	
	else if( cs_get_user_team( iVictim ) == CS_TEAM_CT && g_iTimer > 0 )
	{
		entity_set_int( iVictim, EV_INT_flags, entity_get_int( iVictim, EV_INT_flags ) & ~FL_FROZEN );
				
		MakeScreenFade( iVictim, 0 );
	}
}

public eventSelectKnife( id )
{
	if( cs_get_user_team( id ) == CS_TEAM_T && get_pcvar_num( g_pFakeKnife ) == 1 )
	{
		entity_set_string( id, EV_SZ_viewmodel, "" );
		entity_set_string( id, EV_SZ_weaponmodel, "" );
	}
}

public eventJoinTeam()
{
	if( get_pcvar_num( g_pDeathmatch ) )
	{
		new szName[ 33 ];
		read_data( 3, szName, 32 );
		
		new id = get_user_index( szName );
		
		set_task( 2.5, "taskRespawn", id + TASK_RESPAWN );
	}
}

public msgStatusIcon( iMsgId, iMsgDest, id )
{
	static szMsg[ 8 ];
	get_msg_arg_string( 2, szMsg, 7 );
	
	if( equal( szMsg, g_szBuyzone ) )
	{
		set_pdata_int( id, OFFSET_BUYZONE, get_pdata_int( id, OFFSET_BUYZONE ) & ~( 1<<0 ) );
		
		return PLUGIN_HANDLED;
	}
	
	return PLUGIN_CONTINUE;
}

public msgScreenFade( iMsgId, iMsgDest, id )
{
	if( get_msg_arg_int( 4 ) == 255 && get_msg_arg_int( 5 ) == 255 && get_msg_arg_int( 6 ) == 255 )
	{
		if( cs_get_user_team( id ) == CS_TEAM_T && get_pcvar_num( g_pNoFlash ) 
			|| cs_get_user_team( id ) == CS_TEAM_CT && g_iTimer > 0 )
		{
			return PLUGIN_HANDLED;
		}
	}
	
	return PLUGIN_CONTINUE;
}

public msgTextMsg()
{
	static szMsg[ 33 ];
	get_msg_arg_string( 2, szMsg, 32 );
	
	switch( szMsg[ 1 ] )
	{
		case 'C', 'T', 'H': 
		{
			return PLUGIN_HANDLED;
		}
	}
	
	return PLUGIN_CONTINUE;
}

public client_PreThink( id )
{
	if( !get_pcvar_num( g_pSemiClip ) )
	{
		return FMRES_IGNORED;
	}
		
	static LastThink, i;
	
	if( LastThink > id )
	{
		for( i = 1; i <= g_iMaxPlayers; i++ )
		{
			if( !g_bAlive[ i ] )
			{
				g_bSolid[ i ] = false;
				
				continue;
			}
			
			g_iTeam[ i ] = _:cs_get_user_team( i );
			g_bSolid[ i ] = entity_get_int( i, EV_INT_solid ) == SOLID_SLIDEBOX ? true : false;
		}
	}
			
	LastThink = id;
		
	if( !g_bSolid[ id ] )
	{
		return FMRES_IGNORED;
	}
			
	for( i = 1; i <= g_iMaxPlayers; i++ )
	{
		if( !g_bSolid[ i ] || g_bRestore[ i ] || id == i || entity_range( id, i ) > SEMICLIP_DISTANCE )
		{
			continue;
		}
				
		if( g_iTeam[ i ] == g_iTeam[ id ] )
		{
			g_bRestore[ i ] = true;
			
			entity_set_int( i, EV_INT_solid, SOLID_NOT );
		}
	}
	
	return FMRES_IGNORED;
}

public client_PostThink( id )
{
	if( get_pcvar_num( g_pSemiClip ) )
	{
		static i;
		
		for( i = 1; i <= g_iMaxPlayers; i++ )
		{
			if( g_bAlive[ i ] && g_bRestore[ i ] )
			{
				g_bRestore[ i ] = false;
				
				entity_set_int( i, EV_INT_solid, SOLID_SLIDEBOX );
			}
		}
	}
}

public fwdFullPack( iHandle, e, iEntity, id, iFlags, iPlayer, pSet )
{
	if( !get_pcvar_num( g_pSemiClip ) || !iPlayer || id == iEntity || !g_bAlive[ id ] || !g_bAlive[ iEntity ] )
	{
		return FMRES_IGNORED;
	}
	
	if( g_bSolid[ id ] && g_bSolid[ iEntity ] && g_iTeam[ id ] == g_iTeam[ iEntity ] )
	{
		static Float:fDistance;
		fDistance = entity_range( id, iEntity );
		
		if( fDistance < SEMICLIP_DISTANCE )
		{
			set_es( iHandle, ES_Solid, SOLID_NOT );
			set_es( iHandle, ES_RenderMode, kRenderTransAlpha );
			set_es( iHandle, ES_RenderAmt, floatround( fDistance * 3 ) );
		}
	}
	
	return FMRES_IGNORED;	
}

public fwdPlayerSpawn( id )
{
	if( is_user_alive( id ) )
	{
		g_bAlive[ id ] = true;
		remove_task( id + TASK_RESPAWN );
		
		cs_reset_user_model( id );
		set_user_footsteps( id, get_pcvar_num( g_pFootSteps ) == _:cs_get_user_team( id ) ? 1 : 0 );
		GiveWeapons( id );
	}	
}

public fwdTouchWeapon( iEntity, id )
{
	if( !g_bAlive[ id ] || get_pcvar_num( g_pPickup ) )
	{
		return HAM_IGNORED;
	}
	
	return HAM_SUPERCEDE;
}
				
public fwdCmdStart( id, iHandle )
{
	if( !g_bAlive[ id ] )
	{
		return FMRES_IGNORED;
	}
	
	static iWeapon;
	iWeapon = get_user_weapon( id );
	
	if( iWeapon != CSW_KNIFE )
	{
		return FMRES_IGNORED;
	}
	
	static iButton;
	iButton = get_uc( iHandle, UC_Buttons );
	
	if( cs_get_user_team( id ) == CS_TEAM_T )
	{
		if( iButton & IN_ATTACK ) 
		{
			iButton &= ~IN_ATTACK;
		}
					
		if( iButton & IN_ATTACK2 )
		{
			iButton &= ~IN_ATTACK2;
		}
					
		set_uc( iHandle, UC_Buttons, iButton );
			
		return FMRES_SUPERCEDE;
	}
	
	else if( cs_get_user_team( id ) == CS_TEAM_CT && !g_bAllowSlash )
	{
		if( iButton & IN_ATTACK )
		{
			iButton = iButton & ~IN_ATTACK | IN_ATTACK2;
		}
		
		set_uc( iHandle, UC_Buttons, iButton );
		
		return FMRES_SUPERCEDE;
	}
	
	return FMRES_IGNORED;
}

public fwdSpawn( iEntity )
{
	if( is_valid_ent( iEntity ) )
	{
		new szClass[ 33 ];
		entity_get_string( iEntity, EV_SZ_classname, szClass, 32 );
		
		for( new i = 0; i < sizeof g_szDefaultEntities; i++ )
		{
			if( equal( szClass, g_szDefaultEntities[ i ] ) )
			{
				remove_entity( iEntity );
			}
		}
		
		if( get_pcvar_num( g_pRemoveBreakables ) && equal( szClass, g_szBreakable ) )
		{
			if( entity_get_float( iEntity , EV_FL_takedamage ) )
			{
				remove_entity( iEntity );
			}
		}
		
		if( get_pcvar_num( g_pRemoveDoors ) )
		{
			if( equal( szClass, g_szDoor ) || equal( szClass, g_szDoorRotating ) ) 
			{
				remove_entity( iEntity );
			}	
		}
	}
}

public fwdEmitSound( id, channel, szSound[] )
{
	if( is_user_connected( id ) )
	{
		if( equal( szSound, g_szKnifeDeploy ) && cs_get_user_team( id ) == CS_TEAM_T )
		{
			return FMRES_SUPERCEDE;
		}
	}
	
	return FMRES_IGNORED;
}

public fwdClientKill( id )
{
	if( get_pcvar_num( g_pBlockKill ) )
	{
		return FMRES_SUPERCEDE;
	}
	
	return FMRES_IGNORED;
}

public fwdGameDesc()
{
	new szName[ 33 ];
	get_pcvar_string( g_pGameName, szName, 32 );
	
	if( strlen( szName ) )
	{
		forward_return( FMV_STRING, szName );
		
		return FMRES_SUPERCEDE;
	}
	
	return FMRES_IGNORED;
}

public fwdTimerThink( iEntity )
{
	new iPlayers[ 32 ], iNum, id;
	get_players( iPlayers, iNum, "a" );
	
	if( g_iTimer > 0 )
	{
		for( new i = 0; i < iNum; i++ )
		{
			id = iPlayers[ i ];
			
			if( cs_get_user_team( id ) == CS_TEAM_CT )
			{
				entity_set_int( id, EV_INT_flags, entity_get_int( id, EV_INT_flags ) | FL_FROZEN );
				
				MakeScreenFade( id );
			}
		}
		
		if( get_pcvar_num( g_pSound ) )
		{
			new szSound[ 20 ];
			num_to_word( g_iTimer, szSound, 19 );
			
			client_cmd( 0, "spk vox/%s", szSound );
		}
		
		set_hudmessage( 0, 255, 0, -1.0, 0.82, 0, 0.0, 1.1, 0.0, 0.0, 1 );
		ShowSyncHudMsg( 0, g_iHudSync, "%i секунд до старта...", g_iTimer );
		
		g_iTimer--;
		entity_set_float( iEntity, EV_FL_nextthink, get_gametime() + 1.0 );
	}
		
	else
	{
		for( new i = 0; i < iNum; i++ )
		{
			id = iPlayers[ i ];
			
			if( cs_get_user_team( id ) == CS_TEAM_T && !get_pcvar_num( g_pNadesBeginning ) )
			{
				GiveGrenades( id );
			}
			
			else if( cs_get_user_team( id ) == CS_TEAM_CT )
			{
				entity_set_int( id, EV_INT_flags, entity_get_int( id, EV_INT_flags ) & ~FL_FROZEN );
				
				MakeScreenFade( id, 0 );
			}
		}
		
		if( g_iRoundsLost == get_pcvar_num( g_pSlash ) )
		{
			g_bAllowSlash = true;
			
			GreenPrint( 0, "CT проиграли %i раундов подряд, теперь они могут использовать быстрый удар ножом", get_pcvar_num( g_pSlash ) );
		}
		
		set_hudmessage( 0, 255, 0, -1.0, 0.82, 1, 0.0, 3.0, 0.0, 0.0, 1 );
		ShowSyncHudMsg( 0, g_iHudSync, "Готов или нет, мы идем!" );
		
	}
}

public taskRespawn( id )
{
	id -= TASK_RESPAWN;
	
	if( g_bConnected[ id ] && !g_bAlive[ id ] )
	{
		ExecuteHamB( Ham_CS_RoundRespawn, id );
	}
}

public taskShowMenu( id )
{
	id -= TASK_SHOWMENU;
	
	new szMenu[ 96 ];
	formatex( szMenu, 95, g_szVoteMenu, g_iVotes[ 0 ], g_iVotes[ 1 ] );
	
	show_menu( id, MENU_KEYS, szMenu, 1, "menuGameType" );
}

public taskRemoveStealth( id )
{
	if( g_bConnected[ id ] )
	{
		set_rendering( id );
	}
}

public taskTypeVote()
{
	for( new i = 1; i <= g_iMaxPlayers; i++ )
	{
		if( g_bConnected[ i ] && InTeam( i ) )
		{
			set_task( 0.5, "taskShowMenu", i + TASK_SHOWMENU, _, _, "b" );
		}
	}
	
	set_task( 15.0, "taskEndVote" );
}

public taskEndVote()
{
	for( new i = 1; i <= g_iMaxPlayers; i++ )
	{
		if( g_bConnected[ i ] && InTeam( i ) )
		{
			g_bVoted[ i ] = false;
			
			remove_task( i + TASK_SHOWMENU );
		}
	}
	
	if( g_iVotes[ 0 ] > g_iVotes[ 1 ] || g_iVotes[ 0 ] == g_iVotes[ 1 ] )
	{
		GreenPrint( 0, "Выбран нормальный режим игры" );
		
		if( g_bSecondVote )
		{
			set_pcvar_num( g_pDeathmatch, 0 );
			AlterFakeHostage( 1 );
			
			for( new i = 1; i <= g_iMaxPlayers; i++ )
			{
				if( g_bAlive[ i ] )
				{
					user_silentkill( i );
				}
			}
			
			GreenPrint( 0, "Раунд закончился принудительно.." );
		}
	}
	
	else
	{
		if( g_bSecondVote )
		{
			GreenPrint( 0, "Тип игры Deathmatch будет сохранен" );
		}
		
		else
		{
			set_pcvar_num( g_pDeathmatch, 1 );
			AlterFakeHostage( 0 );
			GreenPrint( 0, "Выбран Deathmatch режим игры" );
		}
	}
	
	g_iVotes[ 0 ] = 0;
	g_iVotes[ 1 ] = 0;
}

public cmdTeamSelect( id )
{
	if( !InTeam( id ) || get_pcvar_num( g_pChooseTeam ) )
	{
		return PLUGIN_CONTINUE;
	}
	
	return PLUGIN_HANDLED;
}

public HandleNadeMenu( id, iKey )
{
	if( !iKey )
	{
		GiveGrenades( id );
	}
}

public HandleTypeMenu( id, iKey )
{
	if( !g_bVoted[ id ] )
	{
		g_bVoted[ id ] = true;
		g_iVotes[ iKey ]++;
	}
}		

AlterFakeHostage( const iResetClass = 0 )
{
	new szClass[ 33 ];
	formatex( szClass, 32, "%s", iResetClass ? "hostage_entity" : "_hostage_entity" );
	
	entity_set_string( g_iHostageEntity, EV_SZ_classname, szClass );
}

GiveWeapons( const id )
{
	strip_user_weapons( id );

	switch( cs_get_user_team( id ) )
	{
		case CS_TEAM_T: 
		{
			if( get_pcvar_num( g_pFakeKnife ) )
			{
				give_item( id, "weapon_knife" );
			}
				
			if( !g_iTimer || get_pcvar_num( g_pNadesBeginning ) )
			{
				GiveGrenades( id );
			}
		}
			
		case CS_TEAM_CT:
		{
			give_item( id, "weapon_knife" );
			
			new iCvar = get_pcvar_num( g_pSmokeGrenade ); 
			
			if( iCvar == 2 || iCvar == 3 )
			{
				give_item( id, "weapon_smokegrenade" );
			}
			
			iCvar = get_pcvar_num( g_pHeGrenade );
			
			if( iCvar == 2 || iCvar == 3 )
			{
				give_item( id, "weapon_hegrenade" );
			}
		}
	}
}

GiveGrenades( const id )
{
	if( get_pcvar_num( g_pFlashbangs ) )
	{
		give_item( id, "weapon_flashbang" );
		cs_set_user_bpammo( id, CSW_FLASHBANG, get_pcvar_num( g_pFlashbangs ) );
	}
				
	new iCvar = get_pcvar_num( g_pSmokeGrenade ); 
			
	if( iCvar == 1 || iCvar == 3 )
	{
		give_item( id, "weapon_smokegrenade" );
	}
			
	iCvar = get_pcvar_num( g_pHeGrenade );
			
	if( iCvar == 1 || iCvar == 3 )
	{
		give_item( id, "weapon_hegrenade" );
	}
}

MakeHiderDm( const id )
{
	cs_set_user_team( id, 1 );
	
	set_user_footsteps( id, get_pcvar_num( g_pFootSteps ) == _:cs_get_user_team( id ) ? 1 : 0 )
	set_rendering( id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 0 );
	
	GiveWeapons( id );
	GiveGrenades( id );
	set_task( 5.0, "taskRemoveStealth", id );
	
	set_hudmessage( 255, 255, 255, -1.0, 0.60, 01, 0.0, 5.0, 0.0, 0.0, 1 );
	ShowSyncHudMsg( id, g_iHudSync, "Уловка.." );
}

MakeScreenFade( const id, const iFade = 1 )
{
	new szColor[ 20 ], szRed[ 4 ], szGreen[ 4 ], szBlue[ 4 ], szAlpha[ 4 ];
	get_pcvar_string( g_pFadeColor, szColor, 19 );
	parse( szColor, szRed, 3, szGreen, 3, szBlue, 3, szAlpha, 3 );
	
	message_begin( MSG_ONE, g_iMsgScreenFade, _, id );
	write_short( 8192 * iFade );
	write_short( 8192 * iFade );
	write_short( 0x0000 );
	write_byte( str_to_num( szRed ) );
	write_byte( str_to_num( szGreen ) );
	write_byte( str_to_num( szBlue ) );
	write_byte( str_to_num( szAlpha ) );
	message_end();
}

GetPlayers( &iTs = 0, &iCTs = 0 )
{
	new iPlayers[ 32 ];
	get_players( iPlayers, iTs, "e", "TERRORIST" );
	get_players( iPlayers, iCTs, "e", "CT" );
	
	if( iTs && iCTs )
	{
		return true;
	}
	
	return false;
}

GreenPrint( const id, const szText[], any:... )
{
	new szMsg[ 192 ], iLen = formatex( szMsg, 191, "^x04[HNS]^x01 " );
	vformat( szMsg[ iLen ], 191 - iLen, szText, 3 );
	
	message_begin( id ? MSG_ONE : MSG_BROADCAST, g_iMsgSayText, _, id );
	write_byte( 1 );
	write_string( szMsg );
	message_end();
}	
